package gov.va.med.mhv.usermgmt.service.impl;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;

import org.tigris.atlas.messages.DefaultMessage;
import org.tigris.atlas.service.VoidServiceResponse;

import gov.va.med.mhv.usermgmt.bizobj.ActivityAssembler;
import gov.va.med.mhv.usermgmt.bizobj.ActivityBO;
import gov.va.med.mhv.usermgmt.bizobj.BusinessObjectFactory;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.ActivityAuditService;
import gov.va.med.mhv.usermgmt.service.ActivityCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.transfer.Activity;


/**
 * Service implementation class for the ActivityAudit service
 */
public class ActivityAuditServiceImpl implements ActivityAuditService {

	/**
	 * Execute the Audit service
	 *
	 * @return VoidServiceResponse
	 */
	public VoidServiceResponse audit(Activity activity) {
		VoidServiceResponse response = new VoidServiceResponse();
		try
		{
	        ActivityBO bo = BusinessObjectFactory.createActivityBO();
	        bo.setActivityValues(activity);
	        bo.save();
	        if( bo.getAllMessages( ).hasErrorMessages( ) ) {	     
	            response.getMessages( ).addMessages( bo.getAllMessages( ) );
	        }	
		}
		catch(Exception x)
		{
			DefaultMessage msg = new DefaultMessage();
			msg.addProperty(x.getLocalizedMessage());
			response.getMessages().addMessage(msg);
		}
		return response;
	}

	public	ActivityCollectionServiceResponse getActivitiesForSubject(Long subjectId, String performerType, Timestamp from, Timestamp to)
	{
		assert subjectId != null;
		ActivityCollectionServiceResponse response = new ActivityCollectionServiceResponse();		
		Collection activities = null;
		
		// Need to add a day to the "To time" so that between is inclusive
		Calendar cal = Calendar.getInstance();
		cal.setTime(to);
		cal.add(Calendar.DATE,1);
		
		try
		{
			if(ActivityActorTypeEnumeration.EVERYONE.equals(performerType)){
				activities = ActivityAssembler.getActivityCollection(ActivityBO.getActivitiesForSubjectByDate(subjectId, from, new Timestamp(cal.getTime().getTime())));
			}
			else if(ActivityActorTypeEnumeration.EVERYONE_BUT_SELF.equals(performerType)){
				activities = ActivityAssembler.getActivityCollection(ActivityBO.getActivitiesForSubjectExceptSelf(subjectId, from, to));
			}
			else{
				activities = ActivityAssembler.getActivityCollection(ActivityBO.getActivitiesForSubjectByTypeByDate(performerType, subjectId, from, to));
			}
		}
		catch(Exception x)
		{
			DefaultMessage msg = new DefaultMessage();
			msg.addProperty(x.getLocalizedMessage());
			response.getMessages().addMessage(msg);
		}
		response.addActivitys(activities);
        return response;		
	}
	
}